﻿using System.Linq;
using Microsoft.AspNet.Mvc;
using Microsoft.AspNet.Mvc.Formatters;
using Newtonsoft.Json;

namespace BindingContextTest.Controllers
{
    public class HomeController : Controller
    {
        public IActionResult Index()
        {
            return View();
        }

        public object TestMethod()
        {
            var testResult = new {
                                 name = "Test",
                                 value = 123,
                                 nullableProperty = (string) null
                             };

            var f = BindingContext.OutputFormatters.FirstOrDefault(
                        formatter => formatter.GetType() == typeof (JsonOutputFormatter)) as JsonOutputFormatter;
            if (f != null) {
                f.SerializerSettings.Formatting = Formatting.Indented;
                f.SerializerSettings.NullValueHandling = NullValueHandling.Ignore;
            }
            return testResult;
        }

        public IActionResult About()
        {
            ViewData["Message"] = "Your application description page.";

            return View();
        }

        public IActionResult Contact()
        {
            ViewData["Message"] = "Your contact page.";

            return View();
        }

        public IActionResult Error()
        {
            return View();
        }
    }
}
