using System.Linq;
using Microsoft.AspNet.Mvc;
using SmartMove.Models;

namespace SmartMove.Controllers
{
    public class TeamsController : Controller
    {
        private readonly MyDBContext _context;

        public TeamsController(MyDBContext context)
        {
            _context = context;    
        }

        // GET: Teams
        public IActionResult Index()
        {
            return View(_context.Teams.ToList());
        }

        // GET: Teams/Details/5
        public IActionResult Details(int? id)
        {
            if (id == null)
            {
                return HttpNotFound();
            }

            Team team = _context.Teams.Single(m => m.TeamId == id);
            if (team == null)
            {
                return HttpNotFound();
            }

            return View(team);
        }

        // GET: Teams/Create
        public IActionResult Create()
        {
            return View();
        }

        // POST: Teams/Create
        [HttpPost]
        [ValidateAntiForgeryToken]
        public IActionResult Create(Team team)
        {
            if (ModelState.IsValid)
            {
                _context.Teams.Add(team);
                _context.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(team);
        }

        // GET: Teams/Edit/5
        public IActionResult Edit(int? id)
        {
            if (id == null)
            {
                return HttpNotFound();
            }

            Team team = _context.Teams.Single(m => m.TeamId == id);
            if (team == null)
            {
                return HttpNotFound();
            }
            return View(team);
        }

        // POST: Teams/Edit/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public IActionResult Edit(Team team)
        {
            if (ModelState.IsValid)
            {
                _context.Update(team);
                _context.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(team);
        }

        // GET: Teams/Delete/5
        [ActionName("Delete")]
        public IActionResult Delete(int? id)
        {
            if (id == null)
            {
                return HttpNotFound();
            }

            Team team = _context.Teams.Single(m => m.TeamId == id);
            if (team == null)
            {
                return HttpNotFound();
            }

            return View(team);
        }

        // POST: Teams/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public IActionResult DeleteConfirmed(int id)
        {
            Team team = _context.Teams.Single(m => m.TeamId == id);
            _context.Teams.Remove(team);
            _context.SaveChanges();
            return RedirectToAction("Index");
        }
    }
}
