﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Globalization;
using System.Linq;
using System.Web;
using System.Web.Script.Serialization;

namespace jqGridInWebForm {
// ReSharper disable InconsistentNaming
    public struct JqGridResults {
        public int page;
        public int total;
        public int records;
        public List<string[]> rows;
    }

    public class User {
        public int UserId { get; set; }
        public string UserName { get; set; }
        public string FirstName { get; set; }
        public string MiddleName { get; set; }
        public string LastName { get; set; }
        public string Email { get; set; }
    }

    public class Users : KeyedCollection<int, User> {
        protected override int GetKeyForItem (User item) {
            return item.UserId;
        }
    }

    internal static class MyRepository {
        internal static Users users = new Users {
            new User {
                UserId = 10,
                FirstName = "Bill",
                LastName = "Gates",
                UserName = "Bill Gates",
                Email = "test@microsoft.com"
            }
        };
        internal static int maxUserId = 10;
    }

    public class jqGridHandler: IHttpHandler {
// ReSharper restore InconsistentNaming
        public void ProcessRequest(HttpContext context) {
            HttpRequest request = context.Request;
            HttpResponse response = context.Response;

            string actionPage = request["ActionPage"];
            string action = request["Action"];

            if (actionPage != "TransportType")
                return;

            switch (action) {
                case "Fill":
                    string numberOfRows = request["rows"];
                    string pageIndex = request["page"];
                    string sortColumnName = request["sidx"];
                    string sortOrderBy = request["sord"];
                    string search = request["isSearch"];
                    string filters = request["filters"];
                    bool isSearch = search != null && String.Compare (search, "true", StringComparison.Ordinal) == 0;
                    string output = BuildJqGridResults (Convert.ToInt32 (numberOfRows), Convert.ToInt32 (pageIndex), sortColumnName, sortOrderBy, isSearch, filters);
                    response.Cache.SetMaxAge (new TimeSpan (0));
                    response.ContentType = "application/json";
                    response.Write (output);
                    break;
                case "Update": {
                        int id = int.Parse (request["id"], CultureInfo.InvariantCulture);
                        User user = MyRepository.users[id];
                        user.UserName = request["UserName"];
                        user.FirstName = request["FirstName"];
                        user.MiddleName = request["MiddleName"];
                        user.LastName = request["LastName"];
                        user.Email = request["Email"];
                        break;
                    }
                case "Insert": {
                        int newId = ++MyRepository.maxUserId;
                        MyRepository.users.Add (new User {
                            UserId = newId,
                            UserName = request["UserName"],
                            FirstName = request["FirstName"],
                            MiddleName = request["MiddleName"],
                            LastName = request["LastName"],
                            Email = request["Email"]
                        });
                        response.Write (newId.ToString (CultureInfo.InvariantCulture));
                        break;
                    }
                case "Delete": {
                        int id = int.Parse (request["id"], CultureInfo.InvariantCulture);
                        MyRepository.users.Remove (id);
                        break;
                    }
            } 

        }

// ReSharper disable UnusedParameter.Local
        private static string BuildJqGridResults(int numberOfRows, int pageIndex,
                                                 string sortColumnName, string sortOrderBy,
                                                 bool isSearch, string filters) {
// ReSharper restore UnusedParameter.Local
            // one should extend the code with sorting paging and filtering of data
            // one can use code from http://stackoverflow.com/a/9349688/315935
            // which is extension of the code from http://stackoverflow.com/a/5501644/315935
            var users = MyRepository.users;
            int totalRecords = users.Count;
            var result = new JqGridResults {
                page = pageIndex,
                total = (totalRecords + numberOfRows - 1)/numberOfRows,
                records = totalRecords,
                rows = (from user in MyRepository.users
                        select new[] {
                            user.UserId.ToString (CultureInfo.InvariantCulture),
                            user.UserName,
                            user.FirstName,
                            user.MiddleName,
                            user.LastName,
                            user.Email
                        }).ToList()
            };
            return new JavaScriptSerializer().Serialize (result);
        }

        public bool IsReusable {
            // To enable pooling, return true here.
            // This keeps the handler in memory.
            get { return false; }
        }
    }
}